type
  TStos = class
    private
      FStos: array of Pointer;
    public
      procedure Po(X: Pointer);
      function Zdejmij: Pointer;
  end;

// -----------------------------------------------------------------------------

type
  TStosCakowity = class
    private
      FStos: array of integer;
    public
      procedure Po(X: Pointer);
      function Zdejmij: Pointer;
  end;

// -----------------------------------------------------------------------------

type
  TStos<T> = class
    private
      FStos: array of T;
    public
      procedure Po(X: T);
      function Zdejmij: T;
  end;

// -----------------------------------------------------------------------------

type
  TWieleTypw<T1, T2, T3, T4> = class;

// -----------------------------------------------------------------------------

var
  StosPrzyciskw: TStos<TButton>;

StosPrzyciskw := TStos<TButton>.Create;

// -----------------------------------------------------------------------------

uses
  SysUtils;

type
  TJakaKlasa<T: constructor> = class
    function GetType: T;
  end;

function TJakaKlasa<T>.GetType: T;
begin
  Result := T.Create;
end;

JakaKlasa := TJakaKlasa<JakiObiekt>;

JakaKlasa := TJakaKlasa<integer>;

// -----------------------------------------------------------------------------

TObjectList<T: class> = class(TList<T>)
private
  FOwnsObjects: Boolean;
protected
  procedure Notify(const Value: T; Action: TCollectionNotification); override;
public
  constructor Create(AOwnsObjects: Boolean = True); overload;
  constructor Create(const AComparer: IComparer<T>; AOwnsObjects: Boolean = True);
              overload;
  constructor Create(Collection: TEnumerable<T>; AOwnsObjects: Boolean = True);
              overload;
  property OwnsObjects: Boolean read FOwnsObjects write FOwnsObjects;
end;

// -----------------------------------------------------------------------------

type
  TJakaKlasa<T: class> = class
    function PodajTyp: T;
  end;

function TJakaKlasa<T>.PodajTyp: T;
begin
  Result := T.Create; // <---- Bd kompilacji
end;

// -----------------------------------------------------------------------------

type
  // Zwr uwag na dodane ograniczenie constructor
  TJakaKlasa<T: class, constructor> = class
    function PodajTyp: T;
  end;

{ TJakaKlasa<T> }

function TJakaKlasa<T>.PodajTyp: T;
begin
  Result := T.Create;
end;

// -----------------------------------------------------------------------------

type
  TMjRekord = record
    LiczbaCakowita: Integer;
  end;

type
  TJakaKlasa<T: record> = class
    private
      FTyp: T;
    public
      constructor Create(aTyp: T);
      function PodajTyp: T;
  end;

constructor TJakaKlasa<T>.Create(aTyp: T);
begin
  inherited Create;
  FTyp := aTyp;
end;

function TJakaKlasa<T>.PodajTyp: T;
begin
  Result := FTyp;
end;

var
  JakaKlasa: TJakaKlasa<TMjRekord>;

// -----------------------------------------------------------------------------

type
  IZatrzymywalny = interface
    procedure Stop;
  end;

TWidet<T: IZatrzymywalny> = class
  FProces: T;
  procedure ZatrzymajProces;
end;

{ TWidet<T> }

procedure TWidet<T>.ZatrzymajProces;
begin
  FProces.Stop;
end;

// -----------------------------------------------------------------------------

type
  TCoTam<T> = class
    JakiTyp: T;
  end;

TJakiRekord = record
  procedure Hej;
end;

var
  CoTam: TCoTam<TJakiRekord>;

procedure TJakiRekord.Hej;
begin
  WriteLn('Hej!');
end;

begin
  CoTam := TCoTam<TJakiRekord>.Create;
  try
    CoTam.JakiTyp.Hej;
  finally
    CoTam.Free;
  end;
end.

// -----------------------------------------------------------------------------

type
  IMjInterfejs<T> = interface
    procedure CoDoZrobienia(aTyp: T);
  end;

// -----------------------------------------------------------------------------

type
  TKreatorWidetw = class
  public
    function UtwrzWidet<T: TWidet>(aNazwaWidetu: string): T;
  end;

{...}

MjWidet := TKreatorWidetw.UtwrzWidet<TSpecjalnyWidet>('SpecjalnyWidet');

// -----------------------------------------------------------------------------

type

  TTowar = class
    ID: integer;
  end;

  TZamwienie = class
    ID: integer;
  end;

  TKlient = class
    ID: TGUID;
  end;

// -----------------------------------------------------------------------------

type

  TElement = class
  end;

  TTowar = class(TElement)
    ID: integer;
  end;

  TZamwienie = class(TElement)
    ID: integer;
  end;

  TKlient = class(TElement)
    ID: TGUID;
  end;

// -----------------------------------------------------------------------------

type

  TJednostka<T> = class
    ID: T;
  end;

  TTowar = class(TJednostka<integer>)
  end;

  TZamwienie = class(TJednostka<integer>)
  end;

  TKlient = class(TJednostka<TGUID>)
  end;

// -----------------------------------------------------------------------------

uses
  TypInfo;

type
  TWylicz = record
  public
    class function JakoCig<T>(aWylicz: T): string; static;
    class function JakoLiczba<T>(aWylicz: T): Integer; static;
  end;

class function TWylicz.JakoCig<T>(aWylicz: T): string;
begin
  Result := GetEnumName(TypeInfo(T), JakoLiczba(aWylicz));
end;

class function TWylicz.JakoLiczba<T>(aWylicz: T): Integer;
begin
  case Sizeof(T) of
    1: Result := pByte(@aWylicz)^;
    2: Result := pWord(@aWylicz)^;
    4: Result := pCardinal(@aWylicz)^;
  end;
end;

// -----------------------------------------------------------------------------

program DemoWylicz;

{$APPTYPE CONSOLE}

uses
  SysUtils;

type
  TWyliczanka = (Ene, Due, Like);

begin
  WriteLn(TWylicz.JakoCig<TWyliczanka>(Ene));  // wywietla 'Ene'
  WriteLn(TWylicz.JakoCig<TWyliczanka>(Due));  // wywietla 'Due'
  WriteLn(TWylicz.JakoCig<TWyliczanka>(Like)); // wywietla 'Like'

  WriteLn(TWylicz.JakoLiczba<TWyliczanka>(Ene));  // wywietla 0
  WriteLn(TWylicz.JakoLiczba<TWyliczanka>(Due));  // wywietla 1
  WriteLn(TWylicz.JakoLiczba<TWyliczanka>(Like)); // wywietla 2

  ReadLn;
end.

// -----------------------------------------------------------------------------

program PrzykadKowariancji;

{$APPTYPE CONSOLE}

uses
  System.SysUtils,
  Generics.Collections;

type
  TRodzic = class
    procedure Raz;
  end;

  TDziecko = class(TRodzic)
    procedure Dwa;
  end;

procedure TDziecko.Dwa;
begin
  WriteLn('Dwa');
end;

procedure TRodzic.Raz;
begin
  WriteLn('Raz');
end;

var
  ListaRodzicw: TList<TRodzic>;

begin
  ListaRodzicw := TList<TDziecko>.Create; // <--- Bd kompilacji
end.
